<?php
$host = $_SERVER['HTTP_HOST'];

if (strpos($host, 'partageriogrande') === false && strpos($host, 'partagesantana') === false && strpos($host, '10.2.0.44') === false) {
  header('Location: /');
  exit();
}

include 'assets/inc/header.php'; ?>
<style>
  @import url('https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300..800;1,300..800&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap');

  * {
    font-family: "Open Sans", sans-serif;
    font-optical-sizing: auto;
    font-style: normal;
  }

  footer,
  header,
  .menu-secundario {
    display: none;
  }

  #hero h1 {
    display: inline-block;
    text-align: left;
  }

  @media screen and (max-width:500px) {
    .d-block-mobile {
      display: block !important;
    }

    .d-block-mobile>div {
      margin-bottom: 20px;
    }
  }

  .opt.show {
    display: none !important;
  }
</style>

<style>
  #banner {
    display: flex;
    align-items: center;
  }

  #banner .fundo {
    width: 100%;
  }

  #banner .bloco {
    position: absolute;
    right: 75px;
    text-align: -webkit-right;
  }

  #banner .bloco h2 {
    color: #fff;
    font-size: 15px;
    font-weight: 400;
    text-align: right;
    text-transform: uppercase;
  }

  #banner .bloco hr {
    width: 170px;
    margin: 15px 0 15px auto;
  }

  #banner .bloco p {
    color: #fff;
    text-align: right;
    font-weight: 100;
    font-size: 15px;
    margin-bottom: 30px;
  }

  #banner .bloco a {
    color: #fff;
    text-decoration: auto;
    width: 227px;
    display: flex;
    align-items: center;
    justify-content: center;
    height: 40px;
    border: solid 1px #fff;
    border-radius: 100px 100px 100px 0;
    transition: all ease 0.3s;
    font-family: "Poppins", sans-serif;
    font-style: normal;
  }

  #banner .bloco a b {
    margin-left: 5px;
  }

  #banner .bloco a:hover {
    transform: scale(1.1);
  }

  .fundoBlocos {
    background-image: url('https://qa-uploads.madnezz.com.br/ca94bce9179e9e9b182c6acdf71a5979');
    background-position: top center;
    background-size: cover;
  }

  #pontos {
    padding: 90px 80px 0;
  }

  #pontos h2 {
    color: #fff;
    font-weight: 300;
    text-align: center;
    font-size: 40px;
    justify-items: center;
  }

  #pontos h2:before {
    content: '';
    display: block;
    margin-bottom: 10px;
    width: 40px;
    height: 40px;
    background-image: url('https://qa-uploads.madnezz.com.br/82fa4e6d3274f9aa27accfac495c72b6');
    background-size: contain;
  }

  #pontos p {
    color: #fff;
    font-family: 'Poppins';
    text-align: center;
    margin: 15px auto;
    max-width: 700px;
    font-weight: 300;
    font-size: 16px;
  }

  #pontos .bloco {
    max-width: 932px;
    border: solid 1px #fff;
    margin: 50px auto 0;
    padding: 30px;
    border-radius: 20px;
    display: flex;
    justify-content: space-between;
    flex-wrap: wrap;
  }

  #pontos .bloco ul {
    border-right: solid 1px #fff;
    margin: 0;
    padding: 26px 0 7px;
  }

  #pontos .bloco li {
    color: #fff;
    max-width: 409px;
    font-family: 'Poppins';
    font-weight: 300;
    margin: 0 25px 30px 60px;
  }

  #pontos .bloco li:before {
    content: '';
    display: block;
    width: 16px;
    height: 16px;
    background-image: url('https://qa-uploads.madnezz.com.br/82fa4e6d3274f9aa27accfac495c72b6');
    background-size: contain;
    position: absolute;
    margin: 5px 0 0 -40px;
  }

  #pontos .bloco .title {
    display: flex;
    justify-content: center;
    align-items: center;
  }

  #pontos .bloco .title h3 {
    margin: 0;
    color: #fff;
    font-family: 'Poppins';
    font-weight: 300;
    font-size: 21px;
    margin-left: 15px;
  }

  #pontos .bloco .title b {
    font-weight: 600;
    font-family: 'Poppins';
  }

  #pontos .bloco .progress-container {
    width: 390px;
    max-width: 100%;
    height: 23px;
    background-color: #ddd;
    border-radius: 100px;
    overflow: hidden;
    margin: 30px 0 0 15px;
  }

  #pontos .bloco .progress-bar {
    width: 69.375%;
    height: 23px;
    background-color: #5edb58;
    text-align: center;
    line-height: 20px;
    color: #d9d9d9;
    border-radius: 50px;
  }

  #pontos .bloco .valores {
    width: 390px;
    max-width: 100%;
    margin: 10px 0 0 15px;
    display: flex;
    justify-content: space-between;
  }

  #pontos .bloco .valores span {
    color: #fff;
    font-size: 19px;
    font-weight: 600;
    font-family: 'Poppins';
  }

  #beneficios {
    padding: 50px 80px 90px;
  }

  #beneficios h2 {
    text-align: center;
    color: #fff;
    font-weight: 300;
    font-size: 30px;
    font-family: 'Poppins';
    max-width: 730px;
    margin: 20px auto;
    line-height: 40px;
  }

  #beneficios .bloco {
    display: flex;
    flex-wrap: wrap;
    gap: 30px;
    max-width: 994px;
    margin: 80px auto 20px;
    justify-content: center;
  }

  #beneficios .bloco .inf {
    width: 311px;
    height: 150px;
    background: #d9d9d9;
    border-radius: 20px;
    display: flex;
    justify-content: space-between;
  }

  #beneficios .bloco .inf .texto {
    width: 155px;
  }

  #beneficios .bloco .inf .texto::before {
    content: '';
    display: block;
    width: 28px;
    height: 30px;
    background-image: url('https://qa-uploads.madnezz.com.br/6d2a1fe43e1549048c53bbeda47934c6');
    background-size: contain;
    margin: 15px 0 0 15px;
  }

  #beneficios .bloco .inf .texto::after {
    content: '';
    width: 91px;
    height: 1px;
    background: #000;
    display: block;
    position: absolute;
    margin: 0 32px;
  }

  #beneficios .bloco .inf .logo-beneficios {
    width: 156px;
    height: 150px;
    border-top-right-radius: 19px;
    border-bottom-right-radius: 19px;
    object-fit: cover;
  }

  #beneficios .bloco .inf p {
    margin: 12px 9px 0;
    text-align: center;
    font-weight: 400;
    font-family: 'Poppins';
    font-size: 16px;
    height: 67px;
  }

  #beneficios .bloco .inf p span {
    font-size: 9px;
  }

  #beneficios .bloco .inf p em {
    font-size: 9px;
    line-height: 9px;
    width: 35px;
    display: inline-block;
    text-align: left;
    margin-left: 5px;
  }

  #participar {
    background: #ffe3de;
    padding: 110px 80px;
    display: flex;
    align-items: center;
    justify-content: space-evenly;
    flex-wrap: wrap;
    gap: 30px;
  }

  #participar .blocTitulo img {
    max-width: 100%;
    width: 143px;
  }

  #participar .blocTitulo h2 {
    color: #572012;
    text-transform: uppercase;
    font-weight: 300;
    font-family: 'Poppins';
    font-size: 40px;
    line-height: 50px;
  }

  #participar .blocTitulo h2 b {
    font-weight: 700;
  }

  #participar .passos {
    width: 100%;
    max-width: 562px;
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
    justify-content: center;
  }

  #participar .bloc {
    border: solid 1px #572012;
    width: 239px;
    height: 143px;
    border-radius: 20px;
    display: flex;
    padding: 15px;
    flex-direction: column;
    align-items: center;
    text-align: center;
  }

  #participar .bloc span {
    background-image: url('https://qa-uploads.madnezz.com.br/b29af263cfc3578e1ba47a4c681bfc00');
    width: 42px;
    height: 42px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #ffe3de;
    font-size: 20px;
    font-weight: 300;
    font-family: 'Poppins';
    padding: 0px 0;
  }

  #participar .bloc h3 {
    color: #572012;
    text-transform: uppercase;
    font-weight: 400;
    font-family: 'Poppins';
    line-height: 24px;
    margin: 14px 0px 10px;
  }

  #participar .bloc h3 b {
    display: block;
  }

  #participar .bloc p {
    margin: 0;
    color: #572012;
    font-size: 11px;
  }

  #categorias {
    background-image: url('https://qa-uploads.madnezz.com.br/6c21104fc8dee227f6ce323dc11d52d6');
    padding: 90px 80px 150px;
    background-position: top right;
    background-size: auto 100%;
    background-repeat: no-repeat;
    background-color: #572015;
  }

  #categorias h2 {
    color: #fff;
    text-transform: uppercase;
    font-family: 'Poppins';
    font-weight: 300;
    font-size: 48px;
    line-height: 55px;
  }

  #categorias h2:before {
    content: '';
    display: block;
    width: 103px;
    height: 103px;
    background-image: url('https://qa-uploads.madnezz.com.br/82fa4e6d3274f9aa27accfac495c72b6');
    margin: 0px 0 0 820px;
    position: absolute;
  }

  #categorias h2 b {
    font-weight: 700;
  }

  #categorias p {
    color: #fff;
    font-weight: 300;
    font-family: 'Poppins';
    max-width: 720px;
  }

  #categorias p span {
    font-size: 12px;
  }

  #categorias .cartoes {
    display: flex;
    flex-wrap: wrap;
    margin: 50px 0 30px;
  }

  #categorias .cartoes .cartao {
    display: flex;
    flex-direction: column;
    margin-right: 30px;
    margin-bottom: 30px;
    gap: 10px;
  }

  #categorias .cartao a {
    background: #fff;
    color: #572015;
    height: 46px;
    width: 260px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 100px;
    text-transform: uppercase;
    text-decoration: none;
    font-size: 13px;
    font-weight: 500;
    transition: ease .3s all;
    margin-right: 8px;
  }

  #categorias .cartao a:hover {
    transform: scale(1.1);
  }

  #celulares {
    background: #572015;
    padding: 0px 80px 90px;
    display: flex;
    align-items: center;
    justify-content: space-evenly;
    flex-wrap: wrap;
  }

  #celulares img.cel {
    margin-top: -40px;
    max-width: 100%;
  }

  #celulares .bloco {
    width: 100%;
    max-width: 495px;
  }

  #celulares .bloco p {
    text-transform: uppercase;
    color: #fff;
    font-weight: 400;
    font-size: 19px;
    margin-bottom: 40px;
    margin-top: 30px;
  }

  #celulares .bloco p b {
    font-size: 36px;
    font-family: 'Open Sans';
  }

  #celulares .bloco a {
    background: #d9d9d9;
    color: #572015;
    height: 40px;
    width: 257px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 100px;
    text-transform: uppercase;
    text-decoration: none;
    font-size: 15px;
    font-weight: 500;
    transition: ease .3s all;
  }

  #celulares .bloco a:hover {
    transform: scale(1.1);
  }

  #faq {
    background: #ffe3de;
    padding: 90px 80px;
    display: flex;
    align-items: center;
    justify-content: space-evenly;
    flex-wrap: wrap;
    gap: 30px;
  }

  #faq img {
    max-width: 100%;
  }

  #faq h2 {
    color: #572015;
    font-weight: 900;
    font-size: 38px;
    text-transform: uppercase;
  }

  #faq .bloco {
    width: 100%;
    max-width: 477px;
  }

  #faq .bloco ul li {
    border-bottom: 1px solid #000;
    padding-bottom: 15px;
    margin-bottom: 30px;
  }

  #faq .bloco ul li:last-child {
    border-bottom: none;
  }

  #faq .bloco ul li b {
    cursor: pointer;
    color: #272727;
    width: 100%;
    display: flex;
    justify-content: space-between;
  }

  #faq .bloco ul li b::after {
    content: '+';
    float: right;
    font-size: 38px;
    margin-top: -17px;
    font-weight: 400;
    height: 30px;
    transition: all ease 0.3s;
  }

  #faq .bloco ul li.ativo b::after {
    content: '-';
    font-size: 66px;
    margin-top: -42px;
  }

  #faq .bloco ul li div {
    transition: none !important;
    font-size: 14px;
  }

  #faq .bloco ul li.ativo div {
    display: block !important;
  }

  #faq .btn {
    display: flex;
    width: 100%;
    align-items: center;
    justify-content: center;
    background: #572015;
    height: 45px;
    border-radius: 15px;
    color: #fff;
    text-transform: uppercase;
    text-decoration: none;
    font-weight: 600;
    font-size: 24px;
    margin: 15px 0 0 0;
    transition: all ease 0.3s;
  }

  #faq .btn:hover {
    transform: scale(1.1);
  }


  @media screen and (max-width:1153px) {
    #pontos .bloco {
      justify-content: center;
    }

    #pontos .bloco ul {
      border-right: none;
      border-bottom: solid 1px #fff;
      margin-bottom: 50px;
    }



  }

  @media screen and (max-width:1199px) {
    #categorias h2 {
      font-size: 37px;
      line-height: 37px;
      padding-top: 85px;
    }

    #categorias h2:before {
      margin: -140px 0 0 0px;
    }

    #categorias {
      background-size: auto 660px;
    }
  }

  @media screen and (max-width:1199px) {
    #banner {
      height: 500px;
      align-items: flex-end;
    }

    #banner .fundo {
      width: 100%;
      object-fit: cover;
      height: 100%;
    }

    #banner .bloco {
      position: absolute;
      left: 0;
      right: 0;
      width: 100%;
      align-items: center;
      margin: 0 auto 40px auto;
      box-sizing: border-box;
      align-content: center;
      justify-items: center;
      text-align: center;
    }

    #banner .bloco a {
      margin: 20px auto 0 auto;
    }

    #banner .bloco img {
      max-width: 80%;
    }

    #banner .bloco hr {
      margin: 15px auto;
    }

    #banner .bloco h2 {
      text-align: center;
    }

    #banner .bloco p {
      text-align: center;
    }
  }

  @media screen and (max-width:1161px) {
    #participar .blocTitulo {
      text-align: center;
    }

    #celulares .bloco {
      text-align: center;
      justify-items: anchor-center;
    }
  }

  @media screen and (max-width:500px) {

    #categorias {
      padding: 90px 30px 100px;
    }

    #faq,
    #participar,
    #pontos {
      padding: 90px 30px;
    }

    #faq .btn {
      font-size: 15px;
      text-align: center;
    }

    #celulares {
      padding: 0px 30px 90px;
    }

    #celulares img.cel {
      margin-bottom: 50px;
    }

  }
</style>

<div class="body">

  <div id="banner">
    <img src="https://qa-uploads.madnezz.com.br/0c2cbe6d6e18175ad1be6587429d5688" alt="Banner fundo" class="fundo">

    <div class="bloco">
      <h2>Transforme suas compras em experiências</h2>
      <img src="https://qa-uploads.madnezz.com.br/4bb5b9f672bf636c4f57a756f44ee576" alt="Logo Oficial Clube">
      <hr>
      <p>Participe do Clube e ganhe benefícios exclusivos<br>ao comprar no Partage Shopping.</p>

      <a href="https://onelink.to/tkdgtp" target="_blank">Cadastre-se <b>agora!</b></a>
    </div>
  </div>

  <div class="fundoBlocos">
    <div id="pontos">
      <h2>CUMPRA MISSÕES NO APP E RECEBA PONTOS</h2>
      <p>A cada R$1,00 gasto, você acumula 1 'partage coin'. desbloqueie missões exclusivas, garantindo benefícios
        únicos a cada conquista!</p>

      <div class="bloco">
        <ul>
          <li>A medida que você escaneia suas notas, você pode acompanhar o progresso da missão, para resgatar sua
            recompensa.</li>
          <li>Ao cumprir a missão você recebe um sms e e-mail com o código de resgate</li>
        </ul>

        <div
          style="max-width: 437px;width: 100%;display: flex;flex-wrap: wrap;justify-content: center;align-content: center;">
          <div class="title">
            <img src="https://qa-uploads.madnezz.com.br/600b1a46a04050358f6cf1b325caace3" alt="Foto Sorverte">
            <h3>
              Acumule <b>R$40,00</b> em NF's<br>
              e <b>ganhe 1 casquinha</b>.
            </h3>
          </div>

          <div class="progress-container">
            <div class="progress-bar" id="myProgressBar"></div>
          </div>

          <div class="valores">
            <span>R$27,75</span>
            <span>R$40,00</span>
          </div>
        </div>
      </div>
    </div>

    <div id="beneficios">
      <h2>CONFIRA ALGUNS DOS BENEFÍCIOS QUE VOCÊ PODE RECEBER AO TÉRMINO DE CADA SESSÃO</h2>

      <div class="bloco">
        <div class="inf">
          <div class="texto">
            <p>
              1 CASQUINHA<br>
              <span>Chocolate, baunilha ou mista</span>
            </p>
          </div>
          <img src="https://qa-uploads.madnezz.com.br/a5448d5f1c6ee691c0d26232df1a11e4" alt="Foto sorverte"
            class="logo-beneficios">
        </div>

        <div class="inf">
          <div class="texto">
            <p>
              1 INGRESSO<br>
              <span>para sessões normais e 3D</span>
            </p>
          </div>
          <img src="https://qa-uploads.madnezz.com.br/51983901dbffffc71e0852a2c1d6e036" alt="Foto Cinema"
            class="logo-beneficios">
        </div>

        <div class="inf">
          <div class="texto">
            <p style="font-size: 20px;">
              R$100<em>em créditos</em><br>
              <span>para a compra de vinhos</span>
            </p>
          </div>
          <img src="https://qa-uploads.madnezz.com.br/545a97c176e5807dcf88ccc64dfdad7e" alt="Foto Vinhos"
            class="logo-beneficios">
        </div>

        <div class="inf">
          <div class="texto">
            <p style="font-size: 20px;">
              90 DIAS <em style="font-size: 14px;width: auto;margin-left: 0;">GRÁTIS</em><br>
              <span>De Spotify Premium</span>
            </p>
          </div>
          <img src="https://qa-uploads.madnezz.com.br/e45e5d259199e29d603e609e7e9a0d3a" alt="Foto Spotify"
            class="logo-beneficios">
        </div>

        <div class="inf">
          <div class="texto">
            <p style="font-size: 20px;">
              R$100<em>em créditos</em><br>
              <span>para refeições no Outback</span>
            </p>
          </div>
          <img src="https://qa-uploads.madnezz.com.br/050e0deacb716024176074eb9b6667e2" alt="Logo do Outback"
            class="logo-beneficios">
        </div>
        <div class="inf">
          <div class="texto">
            <p style="font-size: 20px;">
              R$15<em>em créditos</em><br>
              <span>em restaurantes do MC'Donalds</span>
            </p>
          </div>
          <img src="https://qa-uploads.madnezz.com.br/3542b06b959073a9e1908fb62bb1f317" alt="Logo do McDonald's"
            class="logo-beneficios">
        </div>
      </div>
    </div>
  </div>

  <div id="participar">
    <div class="blocTitulo">
      <img src="https://qa-uploads.madnezz.com.br/6d2a1fe43e1549048c53bbeda47934c6" alt="Logo Oficial">
      <h2>Como participar<br>do <b>Clube Partage?</b></h2>
    </div>
    <div class="passos">
      <div class="bloc">
        <span>1</span>
        <h3>baixe o aplicativo <b>partage shopping</b></h3>

        <p>disponível para ios e android</p>
      </div>
      <div class="bloc">
        <span>2</span>
        <h3>Faça o seu <b>cadastro</b></h3>

        <p>preencha seus dados no app.</p>
      </div>
      <div class="bloc">
        <span style="padding: 6px 0 6px 0;">3</span>
        <h3>Escaneie suas <b>notas fiscais</b></h3>

        <p>escaneie ou digite suas notas<br>(não se esqueça de inserir o cpf).</p>
      </div>
      <div class="bloc">
        <span>4</span>
        <h3><b>Acumule pontos</b></h3>

        <p><b>pronto!</b> você ja está acumulando pontos para trocar por benefícios.</p>
      </div>
    </div>
  </div>

  <div id="categorias">
    <h2>Suba de categoria e<br><b>Multiplique suas vantagens!</b></h2>
    <p>com os pontos acumulados, vocês também pode subir de categoria e garantir benefícios exclusivos com os nossos
      lojistas parceiros*</p>

    <div class="cartoes">
      <div class="cartao">
        <img src="https://qa-uploads.madnezz.com.br/0ca3af1e621caeae3abcb0cd143c4204" alt="Foto cartão Prata"
          style="max-width: 260px">
        <a id="link-prata" href="./clube-partage/categorias.php?categoria=prata">
          Confira os benefícios Prata
        </a>
      </div>

      <div class="cartao">
        <img src="https://qa-uploads.madnezz.com.br/9e0e1e48cad624865ef72bd411edf3d9" alt="Foto cartão Ouro"
          style="max-width: 260px">
        <a id="link-ouro" href="./clube-partage/categorias.php?categoria=ouro">
          Confira os benefícios Ouro
        </a>
      </div>

      <div class="cartao">
        <img src="https://qa-uploads.madnezz.com.br/db57384d475d98d572b6fef088786ec2" alt="Foto cartão Black"
          style="max-width: 260px">
        <a id="link-black" href="./clube-partage/categorias.php?categoria=black">
          Confira os benefícios Black
        </a>
      </div>
    </div>

    <!-- Normaliza os links para a mesma origem (opcional) -->
    <script>
      (function () {
        var base = window.location.origin + "/clube-partage/categorias.php?categoria=";
        document.getElementById("link-prata").href = base + "prata";
        document.getElementById("link-ouro").href = base + "ouro";
        document.getElementById("link-black").href = base + "black";
      })();
    </script>

    <!-- Troca de imagens quando a URL conter "riogrande" -->
    <script>
      (function () {
        var isRioGrande = window.location.href.toLowerCase().includes('riogrande');
        if (!isRioGrande) return; // mantém as imagens originais

        var imgsRioGrande = {
          prata: 'https://qa-uploads.madnezz.com.br/848cde4c158c0088bd464a972bb18295',
          ouro: 'https://qa-uploads.madnezz.com.br/23cd97272555b6c4adff2a312806e275',
          black: 'https://qa-uploads.madnezz.com.br/442a5654db9f6f44adfed3642ea8f474'
        };

        document.querySelectorAll('.cartoes .cartao img').forEach(function (img) {
          var alt = (img.getAttribute('alt') || '').toLowerCase();
          if (alt.includes('prata') && imgsRioGrande.prata) {
            img.src = imgsRioGrande.prata;
          } else if (alt.includes('ouro') && imgsRioGrande.ouro) {
            img.src = imgsRioGrande.ouro;
          } else if (alt.includes('black') && imgsRioGrande.black) {
            img.src = imgsRioGrande.black;
          }
        });
      })();
    </script>

    <p><span>* Benfícios ofertados e administrados diretamente pelos lojistas. Verifique condições e validade
        diretamente na loja.</span></p>
  </div>

  <div id="celulares">
    <img src="https://qa-uploads.madnezz.com.br/cf5bb535d151ae13499b235a4e1abb87" alt="Celulares Clube" class="cel">

    <div class="bloco">
      <img src="https://qa-uploads.madnezz.com.br/2eab765ea74a2ed7d4947fc9ba1eb986" alt="Logo oficial Clube">

      <p>No partage shopping, sua compras valem<br><b>Benefícios exclusivos!</b></p>

      <a href="https://onelink.to/tkdgtp" target="_blank">Baixe o APP e aproveite</a>
    </div>
  </div>

  <div id="faq">
    <img src="https://qa-uploads.madnezz.com.br/6d2a1fe43e1549048c53bbeda47934c6" alt="Logo oficial Clube">

    <div class="bloco">
      <h2>Dúvidas frequentes</h2>

      <ul>
        <li>
          <b>O que é o Clube Partage?</b><br>
          <div style="display: none">O Clube Partage é um programa de relacionamento criado pelos shoppings Partage, uma
            rede presente em diversas regiões do Brasil. Seu objetivo é oferecer benefícios, vantagens exclusivas,
            promoções e experiências diferenciadas para os clientes que realizam compras nos shoppings do grupo.</div>
        </li>

        <li>
          <b>Quem pode participar?</b><br>
          <div style="display: none">Qualquer cliente acima de 18 anos, com CPF válido que realizar compras nos
            shoppings do grupo Partage e atender aos requisitos do regulamento vigente pode participar</div>
        </li>

        <li>
          <b>Tem alguma cobrança para participar do Clube?</b><br>
          <div style="display: none">Não. Participar do Clube é gratuito. Basta se cadastrar no programa e realizar as
            ações previstas para acumular e trocar seus benefícios.</div>
        </li>

        <li>
          <b>Como faço para me cadastrar no Clube Partage?</b><br>
          <div style="display: none">Para se cadastrar, acesse o aplicativo do Shopping Partage, clique em “Cadastre-se”
            ou “Entrar”, preencha seus dados pessoais conforme solicitado e finalize o cadastro. Acesse a área do Clube.
            Após isso, você já poderá participar das missões e aproveitar os benefícios oferecidos.</div>
        </li>

        <li>
          <b>Como funcionam as missões?</b><br>
          <div style="display: none">As missões serão baseadas na leitura de notas fiscais das lojas participantes do
            Partage. A mecânica seguirá o modelo de spending, por exemplo: “Leia X reais em notas fiscais e ganhe uma
            recompensa”.</div>
        </li>

        <li>
          <b>Quem não pode participar das missões?</b><br>
          <div style="display: none">Menores de 18 anos, pessoas com CPF inválido/Cancelado, Lojistas e funcionários do
            grupo Partage.</div>
        </li>

        <li>
          <b>Como faço a leitura da nota fiscal?</b><br>
          <div style="display: none">Para registrar sua nota fiscal, acesse a área destinada no aplicativo do Clube,
            selecione a opção “Ler Nota Fiscal”, escaneie o QR Code ou insira manualmente as informações solicitadas e
            aguarde a validação. São serão validadas notas com o CPF do titular da conta.</div>
        </li>

        <li>
          <b>Como resgato minha recompensa?</b><br>
          <div style="display: none">Para resgatar sua recompensa, acesse sua conta no aplicativo do Shopping, vá até a
            área do Clube Partage e clique em “Minhas Recompensas” onde será possível acompanhar o status e utilizar
            conforme indicado. Você também receberá um SMS e e-mail com o código de resgate.</div>
        </li>

        <li>
          <b>O que fazer se o voucher não funcionar?</b><br>
          <div style="display: none">Tire um print da tela com o momento do erro e entre em contato conosco através da
            Pati, nossa assistente virtual, disponíveis em nosso site e APP.</div>
        </li>

        <li>
          <b>Qual a validade do voucher?</b><br>
          <div style="display: none">30 dias após a sua emissão.</div>
        </li>

        <li>
          <b>Qual o prazo para escanear as Notas Fiscais?</b><br>
          <div style="display: none">30 dias após a sua emissão, porém, recomendamos que faça o procedimento no máximo 2
            dias após a sua impressão, devido o rápido desgaste do papel, dificultando a leitura dos dados.</div>
        </li>

        <li>
          <b>Como é tratada a minha privacidade?</b><br>
          <div style="display: none">A Política de Privacidade do Clube Partage rege o tratamento dos seus dados
            pessoais. Certifique-se de mantê-los sempre atualizados para usufruir plenamente dos benefícios. Para mais
            detalhes, consulte o documento disponível no aplicativo do Shopping sessão Clube Partage.</div>
        </li>
      </ul>

      <a href="https://qa-uploads.madnezz.com.br/d1400b23ed44ba5dc678a88ebc2f95c2" target="_blank" class="btn">Confira o
        regulamento</a>
    </div>
  </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="clube-partage/categorias.js" defer></script>
